<?php

include_once('orthophoto_stream.php'); // Klasa musi zosta zadeklarowana
                                       // jeszcze przed prb jej uycia.
function display_orthophoto($northing, $easting, $radius)
{
    $filename = sprintf('nzmg://%07d%07d%07d', $northing, $easting, $radius);

    // Tu wykonywane s wszystkie operacje zwizane ze strumieniami.
    $image = imagecreatefrompng($filename);

    // Lekki retusz obrazu, eby podany kod nie by tak zupenie trywialny.
    // Rysujemy koo o podanym promieniu (sam obraz jest w kocu prostoktny),
    // a w jego rodku umieszczamy krzyyk.
    // Musimy odnale warto bieli w obrazie.
    $white = imagecolorexact($image, 255, 255, 255);
    if($white==-1) // No dobrze, na obrazie nie ma nic biaego.
        $white = imagecolorallocate($image, 255, 255, 255);
    // Koo musi znale si na rodku obrazu i mie taki promie,
    // eby dotyka krawdzi obrazu.
    $imagesize = imagesx($image);
    $middle = $imagesize>>1;
    imageellipse($image, $middle, $middle, $imagesize, $imagesize, $white);
    imageline($image, $middle, $middle+5, $middle, $middle-5, $white);
    imageline($image, $middle+5, $middle, $middle-5, $middle, $white);
    imagestring($image, 0, 0, 0,
                'Sourced from Orthophoto R11 Auckland Crown Copyright Reserved.',
                $white);
    imagepng($image);
    imagedestroy($image);
}

?>
